/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.recipe;

import com.google.gson.JsonObject;
import com.hoshino.cti.util.JsonUtil;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class AtmosphereCondensorRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final FluidStack output;
    private final String BiomeString;
    private final Ingredient ingredient = Ingredient.f_43901_;

    public AtmosphereCondensorRecipe(ResourceLocation id, FluidStack output, String BiomeString) {
        this.id = id;
        this.output = output;
        this.BiomeString = BiomeString;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return !pLevel.m_5776_();
    }

    public String getBiome() {
        return this.BiomeString;
    }

    public FluidStack getFluid() {
        return this.output;
    }

    public ItemStack assemble(SimpleContainer pContainer) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Deprecated
    public static class Serializer
    implements RecipeSerializer<AtmosphereCondensorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("cti", "atmosphere_condense");

        public AtmosphereCondensorRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            FluidStack output = JsonUtil.readFluid(pSerializedRecipe, "output");
            String biome = GsonHelper.m_13906_((JsonObject)pSerializedRecipe, (String)"biome");
            return new AtmosphereCondensorRecipe(pRecipeId, output, biome);
        }

        @Nullable
        public AtmosphereCondensorRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            FluidStack output = pBuffer.readFluidStack();
            String biome = pBuffer.m_130277_();
            return new AtmosphereCondensorRecipe(pRecipeId, output, biome);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, AtmosphereCondensorRecipe pRecipe) {
            pBuffer.m_130085_(pRecipe.id);
            pBuffer.writeInt(pRecipe.m_7527_().size());
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130070_(pRecipe.getBiome());
            pBuffer.writeFluidStack(pRecipe.getFluid());
        }
    }

    public static class Type
    implements RecipeType<AtmosphereCondensorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "atmosphere_condense";

        private Type() {
        }
    }
}

